#!/bin/sh
########################################################################
########################################################################
#                                                                      #
#  This script will display a save-file dialog.                        #
#                                                                      #
#  Requires the following scripts:                                     #
#  (refer to PATHS section for actual filepaths)                       #
#      NONE                                                            # 
#                                                                      #
#  Parameters: <title> <file filter> <filename>                        #
########################################################################

# Dialog title
title=$1

# File filter to used
filter=$2

# Default filename
filename=$3

# Check if zenity is available
zenity --help > /dev/null 2>&1
ret=$?
if [ $ret -eq 0 ]; then
	zenity --title="${title}" --file-selection --save --confirm-overwrite --file-filter="${filter}" --filename="${filename}"
	ret=$?
	# If 255(option not available) error is received
	if [ $ret -eq 255 ]; then
		# Launch file dialog without the file filter option
		zenity --title="${title}" --file-selection --save --confirm-overwrite  --filename="${filename}"
	fi
	#zenity --file-selection --save --confirm-overwrite --file-filter="${filter}" --filename="${filename}"
else
	kdialog --getsavefilename "${filename}" 2> /dev/null
	ret=$?
fi
return $ret

